#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 20000

typedef struct {
    double x, y;
    int id;
} Point;

int used[500][500];

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Point p[MAXN];
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &p[i].x, &p[i].y);
        p[i].id = i + 1;
    }

    int k = 0;
    int chosen[MAXN];

    int grid = (int)(1.0 / eps) + 2;

    for (int i = 0; i < n; i++) {
        int gx = (int)(p[i].x / eps);
        int gy = (int)(p[i].y / eps);

        if (!used[gx][gy]) {
            used[gx][gy] = 1;
            chosen[k++] = i;
        }
    }

    printf("%d\n", k);
    for (int i = 0; i < k; i++)
        printf("%d ", p[chosen[i]].id);
    printf("\n");


    for (int i = 1; i < k; i++) {
        printf("%d %d\n",
               p[chosen[i - 1]].id,
               p[chosen[i]].id);
    }

    return 0;
}